#version 140
#extension GL_EXT_gpu_shader4 : enable
//Jello lens2Mod01.fsh by Shellderr
//https://www.shadertoy.com/view/tl3yz7
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define iMouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define rr(s) (s*0.5+0.5)
#define dst(v) (length(uv-v))

vec2 bnc(float t,vec2 p){
    return abs(fract(p*t*0.05)-0.5)*4.-1.;
}

float ss(float t){
    return (3.*sin(t)*sin(t)+2.*cos(t)) *sin(t);
}

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (2.*gl_FragCoord.xy-iResolution.xy)/iResolution.y;
    
    float mm = 7.;
    float mag = 1.0;
    
    mm += 10.*iMouse.y/iResolution.y;

    vec2 p = bnc(iTime,vec2(3.22,4.64));
    vec2 p2 = bnc(iTime,vec2(2.72,3.74));
    vec2 p3 = bnc(iTime,vec2(3.88,1.87));

    float d = log(mag+(sin(dst(p)*mm)));
    
    d *= log(mag+(sin(dst(p2)*mm)));
    d *= log(mag+(sin(dst(p3)*mm)));

    d += dst(vec2(0.))*33.;
    
    gl_FragColor =  vec4( vec3( rr(ss(d)),0., rr(ss(d)) ), 1.0 );
}




